<?php  

/**
 * summary
 */
class FancyFikter_Lite_permalink
{
    /**
     * summary
     */
    public function __construct()
    {
     
     add_action('load-options-permalink.php', array($this,'fancy_cpt_load_permalinks')); 

     add_action('edit_form_after_title', array($this,'in_admin_header_lw'));  
    }



    function in_admin_header_lw() {
       $screen = get_current_screen();
       $current_status = get_post_status (get_the_ID());
       if($screen->post_type=='fancyfilter' && $screen->id=='fancyfilter' && ($current_status == 'publish')) {
          echo "<em class='fncytitlewrap'>Change the Permalink from the <a href='options-permalink.php'>Permalinks page</a></em>";
       }
    }
   
   function fancy_cpt_load_permalinks()
   {
    $nonce = wp_create_nonce( 'fancyfilter-nonce' );
    if ( ! wp_verify_nonce( $nonce, 'fancyfilter-nonce' ) ) return;

      if( isset( $_POST['fancy_cpt_base'] ) )
      {
         update_option( 'fancy_cpt_base', sanitize_title_with_dashes( wp_unslash($_POST['fancy_cpt_base'] )) );
      }
      
      // Add a settings field to the permalink page
      add_settings_field( 'fancy_cpt_base', esc_html( 'Fancy Filter Custom Permalink' ), array($this ,'fancy_cpt_field_callback'), 'permalink', 'optional', array('class' => 'fancyfiklteraaddon') );

   }

   function fancy_cpt_field_callback()
   {
      $value = get_option( 'fancy_cpt_base' ); 

     $tiembav =  $value ? $value : 'fancyfilter';
      echo '<input type="text" value="' . esc_attr( $tiembav ) . '" name="fancy_cpt_base" id="fancy_cpt_base" class="regular-text" /><p class="description"><em>Change the permalink of the fancy portfolio</em></p>';
   }
}
if(class_exists('FancyFikter_Lite_permalink')){

	new FancyFikter_Lite_permalink();
}