<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://sharabindu.com
 * @since      2.0.3
 *
 * @package    fancyfilter_pro
 * @subpackage fancyfilter_pro/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    fancyfilter_pro
 * @subpackage fancyfilter_pro/admin
 * @author     Sharabindu <sharabindu.bakshi@gmail.com>
 */
class fancyfilter_freeMore {


	public function __construct() {

		add_action( 'init', array($this, 'fancyfilter_addfilter_type'));

		add_filter( 'post_updated_messages', array($this,'rw_post_updated_messages' ));

	}


	/**
	 * My Post Type update messages.
	 *
	 * See /wp-admin/edit-form-advanced.php
	 *
	 * @param array $messages Existing post update messages.
	 *
	 * @return array Amended post update messages with new CPT update messages.
	 */

	function rw_post_updated_messages( $messages ) {

    $nonce = wp_create_nonce( 'fancyfilter-nonce' );
    if ( ! wp_verify_nonce( $nonce, 'fancyfilter-nonce' ) ) return;

		$post             = get_post();
		$post_type        = get_post_type( $post );
		$post_type_object = get_post_type_object( $post_type );
		
		$messages['morefilter'] = array(
			0  => '', // Unused. Messages start at index 1.
			1  => esc_html( 'Shortcode updated.' ),
			2  => esc_html( 'Shortcodeupdated.' ),
			3  => esc_html( 'Shortcode deleted.'),
			4  => esc_html( 'Shortcode updated.' ),
			/* translators: %s: date and time of the revision */
			5  => isset( $_GET['revision'] ) ? sprintf( esc_html( 'Shortcode restored to revision from %s' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
			6  => esc_html( 'Shortcode published.' ),
			7  => esc_html( 'Shortcode saved.' ),
			8  => esc_html( 'Shortcode submitted.' ),
			9  => sprintf(
				esc_html( 'Shortcode scheduled for: <strong>%1$s</strong>.' ),
				// translators: Publish box date format, see http://php.net/date
				date_i18n( esc_html( 'M j, Y @ G:i' ), strtotime( $post->post_date ) )
			),
			10 => esc_html( 'Shortcode draft updated.' )
		);

	        //you can also access items this way
	        // $messages['post'][1] = "I just totally changed the Updated messages for standards posts";

	        //return the new messaging 
		return $messages;
	}









	function fancyfilter_addfilter_type() {

		$labels = [
			"name" => esc_html__( "Create Shortcode", "fancy-fiter" ),
			"singular_name" => esc_html__( "Create Shortcode", "fancy-fiter" ),
			"menu_name" => esc_html__( "Create Shortcode", "fancy-fiter" ),
			"all_items" => esc_html__( "All shortcodes", "fancy-fiter" ),
			"add_new" => esc_html__( "Add New Shortcode", "fancy-fiter" ),
			"add_new_item" => esc_html__( "Add New Shortcode", "fancy-fiter" ),
			"edit_item" => esc_html__( "Edit Shortcode", "fancy-fiter" ),
			"new_item" => esc_html__( "New Shortcode", "fancy-fiter" ),
			"view_item" => esc_html__( "View Shortcode", "fancy-fiter" ),
			"view_items" => esc_html__( "View All Shortcode", "fancy-fiter" ),
			"search_items" => esc_html__( "Search Shortcode", "fancy-fiter" ),
			"not_found" => esc_html__( "Not Found Shortcode", "fancy-fiter" ),
			"not_found_in_trash" => esc_html__( "Not  found in Trash", "fancy-fiter" ),
			"parent" => esc_html__( "Parent", "fancy-fiter" ),
			"featured_image" => esc_html__( "Portfolio Image", "fancy-fiter" ),
			"set_featured_image" => esc_html__( "Set Portfolio Image", "fancy-fiter" ),
			"remove_featured_image" => esc_html__( "Remove Portfolio Image", "fancy-fiter" ),
			"use_featured_image" => esc_html__( "Use Portfolio Image", "fancy-fiter" ),
			"archives" => esc_html__( "Portfolio Archive", "fancy-fiter" ),
			"parent_item_colon" => esc_html__( "Parent", "fancy-fiter" ),
		];



		$args = [
			"label" => esc_html__( "Fancy Filter", "fancy-fiter" ),
			"labels" => $labels,
			"description" => "Fancy Filter is a Portfolio Filter Plugin",
			"public" => false,
			"publicly_queryable" => false,
			"show_ui" => true,
			"delete_with_user" => false,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"has_archive" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => true,
			"menu_icon" => "dashicons-grid-view",
			"rewrite" => true,
			'show_in_menu' => 'edit.php?post_type=fancyfilter',
			"query_var" => true,
			"supports" => [ "title"],
		];

		register_post_type( "morefilter", $args );


}
}
if(class_exists("fancyfilter_freeMore")){

	new fancyfilter_freeMore();
}