<?php
/**
 * The file that defines the bulk print admin area
 *
 * public-facing side of the site and the admin area.
 *
 * @link       https://sharabindu.com
 * @since      2.0.3
 *
 * @package    fancy-filter
 * @subpackage fancy-filter/admin
 */

class FanctFilyer_liteto_use
{

    public function __construct()
    {

        add_action('admin_menu', array(
            $this,
            'admin_menu_define'
        ));

        add_action('admin_head', array(
            $this,
            'my_custom_admin_head'
        ));
    }

    function my_custom_admin_head()
    {
        echo '    ';
    }

    function elfi__settting_func()
    {

        return;
    }

    public function admin_menu_define()
    {

        add_submenu_page('edit.php?post_type=fancyfilter', __('How It Works', 'fancy-fiter') , __('How It Works <span class="dashicons dashicons-controls-forward"></span>', 'fancy-fiter') , 'manage_options', 'how_it_works', array( $this, 'how_to_use'));
 

    }

       function how_to_use()
       {

   ?>

        <div class="yoobaradmin__codewrap">
           <div class="yoobar_tirmoof" >


         <div class="yoobar-feature">
           <ul>

             <li  class="fancyfilter_tabs_li"  style="background: url(<?php echo esc_url( FANCYFILTER_URL) . '/assets/admin/img/docsimage.jpg' ?>)">
               <ul class="fancyfilter_tabs">
                 <li>
                 <p> <?php echo esc_html__('Step: 1', 'fancy-fiter') ?><span class="dashicons dashicons-controls-forward"></span> <?php echo esc_html__('Create Category and add to post(post,product,fancy)', 'fancy-fiter') ?> </p>  
                 </li>
                 <li>
                 <p> <?php echo esc_html__('Step: 2', 'fancy-fiter') ?><span class="dashicons dashicons-controls-forward"></span> <?php echo esc_html__('Go to the Settings and set the setting options ', 'fancy-fiter') ?>  </p>  
                 </li>
                 <li>
                 <p> <?php echo esc_html__('Step: 3', 'fancy-fiter') ?><span class="dashicons dashicons-controls-forward"></span>  <?php echo esc_html__('Copy the shortcode from the Item Settings tab and paste it in the desired location', 'fancy-fiter') ?> </p>  
                 </li>
               </ul></li>
             <li class="yoobar-feature_6">
              <img class='yoo_dcs_img' src=" <?php echo esc_url(FANCYFILTER_URL) . '/assets/admin/img/docs.svg' ?>"> 
           <h3 class="yoobar-feature-title"> <?php echo esc_html__('How to Use', 'fancy-fiter') ?></h3>
           <p class="feature-title18"> <?php echo esc_html__('We have created full-proof documentation for you. It will help you to understand how our plugin works.', 'fancy-fiter') ?></p>
           <div>
           <a class="ydocsbutn" href="https://fancyfilter.dipashi.com/docs/introduction/" target="_blank"><?php echo esc_html__('Documentation', 'fancy-fiter') ?></a>
           </div>
           </li>
           </ul>


         </div>
         <div class="yoobar-feature">
           <ul>
             <li class="yoobar-feature_6 fswr">
              <img class='yoo_dcs_img' src=" <?php echo esc_url(FANCYFILTER_URL) . '/assets/admin/img/question.svg' ?>"> 

           <h3 class="yoobar-feature-title"><?php echo esc_html__('FAQ', 'fancy-fiter') ?></h3>
           <p class="feature-title18"><?php echo esc_html__('Frequently Asked Questions', 'fancy-fiter') ?></p>

           <div class="yoofaqdes">
         <h4><?php echo esc_html__('Will this plugin work on all themes?', 'fancy-fiter') ?></h4>
         <p><?php echo esc_html__('Yes, it will work on all kinds of themes. Use it to bring colorful moments to your site. And don’t forget to check out our premium features.', 'fancy-fiter') ?></p>
         </div>
         <div class="yoofaqdes">
         <h4><?php echo esc_html__('Is there any support available for the free users?', 'fancy-fiter') ?></h4>
         <p><?php echo esc_html__('Both the free and pro versions bring great support from us. However Pro users will get priority support.', 'fancy-fiter') ?></p>
         </div>

           </li>
           </ul>

         </div>
         <div class="yoobar-feature">
           <ul>
             <li class="yoobar-feature_6">
              <img class='yoo_dcs_img' src=" <?php echo esc_url( FANCYFILTER_URL ). '/assets/admin/img/start.svg' ?>"> 
           <h3 class="yoobar-feature-title"><?php echo esc_html__('Getting Started', 'fancy-fiter') ?></h3>
           <p class="feature-title18"><?php echo esc_html__('Getting started with Fancy Filter is very easy, just click the button below and create the first Portfolio on your site', 'fancy-fiter') ?></p>
           <div>
           <a class="ydocsbutn" href="<?php echo esc_url(admin_url('post-new.php?post_type=fancyfilter')); ?> "><?php echo esc_html__('Add A New Portfolio', 'fancy-fiter') ?></a>
           </div>
           </li>

           <li><img src=" <?php echo esc_url( FANCYFILTER_URL) . '/assets/admin/img/startedmin.png' ?>"></li>
           </ul>

         </div>
         <div class="yoobar-feature">
           <ul>
             <li class="yoobar-feature_6 fswr" style="text-align: center;">
              <img class='yoo_dcs_img' src=" <?php echo esc_url( FANCYFILTER_URL) . '/assets/admin/img/support.svg' ?>"> 

           <h3 class="yoobar-feature-title"><?php echo esc_html__('Support', 'fancy-fiter') ?></h3>
           <p class="feature-title18"><?php echo esc_html__('Feeling like consulting an expert? Get our live chat support. We are always ready to help you.', 'fancy-fiter') ?></p>

           <div>
             <a class="ydocsbutn" href="https://wordpress.org/support/plugin/fancy-fiter/" target="_blank"><?php echo esc_html__('Get Support', 'fancy-fiter') ?></a>
             </div>

           </li>
           </ul>

         </div>

         <div class="yoobar-feature">
           <ul>
             <li class="yoobar-feature_6">

           <h3 class="yoobar-feature-title"><?php echo esc_html__('Missing Any Features', 'fancy-fiter') ?></h3>
           <p style="width:90%"><?php echo esc_html__('Do you need any features that we don\'t have in our plugin? Let us know Feel free to do a request from here', 'fancy-fiter') ?></p>
           <a class="ydocsbutn" href="https://sharabindu.com/what-features-want-to-see/" target="_blank" style="background: #e2498a"><?php echo esc_html__('Request Feature', 'fancy-fiter') ?></a>
           </li>
           <li><img src=" <?php echo esc_url( FANCYFILTER_URL) . '/assets/admin/img/missing.jpg' ?>"></li>

           </ul>

         </div>

         <div class="yoobar-feature">
           <div id="yooshado">
           <ul>

             <li><img src=" <?php echo esc_url( FANCYFILTER_URL) . '/assets/admin/img/review.svg' ?>"></li>
             <li class="yoobar-feature_67">

           <h3 class="yoobar-feature-title"><?php echo esc_html__('Happy with Our Plugin?', 'fancy-fiter') ?></h3>
           <p class="feature-title18"><?php echo esc_html__('We are really grateful that you have chosen our plugin. If you like our plugin, please share your happiness by giving us a 5star rating in WordPress Org. It will delight us and will not take more than 2 minutes.', 'fancy-fiter') ?></p>
           <a class="ydocsbutn" href="https://wordpress.org/plugins/fancy-fiter/#reviews" target="_blank"><?php echo esc_html__('Give us 5*', 'fancy-fiter') ?></a>
           </li>
           </ul>
           </div>
         </div>

         </div>
       </div>


       <?php
       }

   }

if (class_exists('FanctFilyer_liteto_use'))
{
    new FanctFilyer_liteto_use;
};

